<?php

namespace App\Http\Controllers\Therapists;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Event;
use App\Http\Requests\Therapists\TherapistEvents\CreateRequest;
use App\Http\Resources\Web\EventsResource;
use Carbon\Carbon;
use Excel;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

class TherapistEventsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('therapist');
        // $this->middleware('permission:therapist_events.index');
        // $this->middleware('permission:therapist_events.create',['only' => ['store']]);
        // $this->middleware('permission:therapist_events.update',['only' => ['update']]);
        // $this->middleware('permission:therapist_events.delete',['only' => ['destroy']]);
        // $this->middleware('permission:therapist_events.export',['only' => ['export']]);
        // $this->middleware('permission:therapist_events.import',['only' => ['import']])
        // $this->middleware('permission:therapist_events.update|therapist_events.is_active',['only' => ['updateStatus']]);
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public function getter($req = null, $export = null)
    {
        $therapist = auth()->user()->therapist;
        if ($req != null) {
            $therapist_events =  $therapist->therapist_events()->withAll();
            if ($req->trash && $req->trash == 'with') {
                $therapist_events =  $therapist_events->withTrashed();
            }
            if ($req->trash && $req->trash == 'only') {
                $therapist_events =  $therapist_events->onlyTrashed();
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapist_events = $therapist_events->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {

                $therapist_events = $therapist_events->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort && $req->sort['field'] != null && $req->sort['type'] != null) {
                $therapist_events = $therapist_events->OrderBy($req->sort['field'], $req->sort['type']);
            } else {
                $therapist_events = $therapist_events->OrderBy('id', 'desc');
            }
            if ($export != null) { // for export do not paginate
                $therapist_events = $therapist_events->get();
                return $therapist_events;
            }
            $totalTherapistEvents = $therapist_events->count();
            $therapist_events = $therapist_events->paginate($req->perPage);
            $therapist_events = EventsResource::collection($therapist_events)->response()->getData(true);

            return $therapist_events;
        }
        $therapist_events = EventsResource::collection($therapist->therapist_events()->withAll()->orderBy('id', 'desc')->paginate(10))->response()->getData(true);
        return $therapist_events;
    }

    /********* FETCH ALL TherapistEvents ***********/
    public function index()
    {
        $therapist_events =  $this->getter();
        $response = generateResponse($therapist_events, count($therapist_events['data']) > 0 ? true : false, 'TherapistEvents Fetched Successfully', null, 'collection');
        return response()->json($response, 200);
    }

    /********* FILTER TherapistEvents FOR Search ***********/
    public function filter(Request $request)
    {
        $therapist_events = $this->getter($request);
        $response = generateResponse($therapist_events, count($therapist_events['data']) > 0 ? true : false, 'Filter TherapistEvents Successfully', null, 'collection');
        return response()->json($response, 200);
    }

    /********* ADD NEW TherapistEvent ***********/
    public function store(CreateRequest $request)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        try {
            DB::beginTransaction();
            $request->merge(['created_by_user_id' => auth()->user()->id]);
            $data = $request->all();
            $data['image'] = uploadCroppedFile($request, 'image', 'therapist_events');
            $therapist_event = $therapist->therapist_events()->create($data);
            $therapist_event->slug = Str::slug($therapist_event->name . ' ' . $therapist_event->id, '-');
            $therapist_event->save();
            $therapist_event = $therapist->therapist_events()->withAll()->find($therapist_event->id);
            foreach ($request->sponsers as $sponser) {
                $image_url = uploadArrayFile($sponser, 'image', 'event_sponsers');
                $therapist_event->sponsers()->create([
                    'name' => $sponser['name'],
                    'image' => $image_url
                ]);
            }
            $therapist_event = new EventsResource($therapist_event);
            $therapist_event->tags()->sync($request->tag_ids);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
            return redirect()->back()->withErrors(['line' => $e->getLine(), 'message' => $e->getMessage()]);
        }
        return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show($therapist_event)
    {
        $therapist = auth()->user()->therapist;
        if ($therapist_event->therapist_id != $therapist->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_event = $therapist->therapist_events()->withAll()->find($therapist_event);
        if ($therapist_event) {
            $therapist_event = new EventsResource($therapist_event);
            $response = generateResponse($therapist_event, true, 'TherapistEvent Fetched Successfully', null, 'object');
        } else {
            $response = generateResponse(null, false, 'TherapistEvent Not FOund', null, 'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistEvent ***********/
    public function update(CreateRequest $request, Event $therapist_event)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if ($therapist_event->therapist_id != $therapist->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        try {
            DB::beginTransaction();
            $request->merge(['last_updated_by_user_id' => auth()->user()->id]);
            $data = $request->all();
            if ($request->image) {
                $data['image'] = uploadCroppedFile($request, 'image', 'therapist_events', $therapist_event->image);
            } else {
                $data['image'] = $therapist_event->image;
            }

            $therapist_event->update($data);
            $therapist_event = $therapist_event->find($therapist_event->id);
            $slug = Str::slug($therapist_event['name'] . ' ' . $therapist_event->id, '-');
            $therapist_event->update(
                [
                    'slug' => $slug
                ]
            );
            $therapist_event->sponsers()->delete();
            foreach ($request->sponsers as $sponser) {
                if (is_string($sponser['image'])) {
                    $image_url = $sponser['previous_image'];
                } else {
                    $image_url = uploadArrayFile($sponser, 'image', 'event_sponsers');
                }
                $therapist_event->sponsers()->create([
                    'name' => $sponser['name'],
                    'image' => $image_url
                ]);
            }
            $therapist_event->tags()->sync($request->tag_ids);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
            return redirect()->back()->withErrors(['line' => $e->getLine(), 'message' => $e->getMessage()]);
        }
        return redirect()->back();
    }

    /********* UPDATE TherapistEvent Status***********/
    public function updateStatus(Request $request, Event $therapist_event)
    {
        $therapist = auth()->user()->therapist;
        if ($therapist_event->therapist_id != $therapist->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_event->update([
            'is_active' => $therapist_event->is_active == 1 ? 0 : 1
        ]);
        $response = generateResponse(null, true, 'TherapistEvent Status Updated Successfully', null, 'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistEvent ***********/
    public function destroy(Request $request, Event $therapist_event)
    {
        $therapist = auth()->user()->therapist;
        if ($therapist_event->therapist_id != $therapist->id) {
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
            return redirect()->back();
        }
        if ($therapist_event->trashed()) {
            request()->session()->flash('alert', ['message' => 'Already in Trash', 'type' => 'error']);
        } else {
            $therapist_event->sponsers()->delete();
            $therapist_event->delete();
        }
        return redirect()->back();
    }
    /*********Permanently DELETE TherapistEvent ***********/
    public function destroyPermanently(Request $request, $therapist_event)
    {
        $therapist = auth()->user()->therapist;
        $therapist_event = $therapist->therapist_events()->withTrashed()->find($therapist_event);
        if ($therapist_event) {
            if ($therapist_event->therapist_id != $therapist->id) {
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
            if ($therapist_event->trashed()) {
                $therapist_event->forceDelete();
                $response = generateResponse(null, true, 'TherapistEvent Deleted Successfully', null, 'object');
            } else {
                $response = generateResponse(null, false, 'TherapistEvent is not in trash to delete permanently', null, 'object');
            }
        } else {
            $response = generateResponse(null, false, 'TherapistEvent not found', null, 'object');
        }
        return response()->json($response, 200);
    }
    /********* Restore TherapistEvent ***********/
    public function restore(Request $request, $therapist_event)
    {
        $therapist = auth()->user()->therapist;
        $therapist_event = $therapist->therapist_events()->withTrashed()->find($therapist_event);
        if ($therapist_event->trashed()) {
            $therapist_event->restore();
            $response = generateResponse(null, true, 'TherapistEvent Restored Successfully', null, 'object');
        } else {
            $response = generateResponse(null, false, 'TherapistEvent is not trashed', null, 'object');
        }
        return response()->json($response, 200);
    }
}
